/*
 * Decompiled with CFR 0.152.
 */
package core.modes;

import core.GameWindow;
import core.enums.State;
import core.modes.GameMode;
import core.states.GameState;
import entities.Entity;
import entities.creatures.enemies.touhou.TouhouEmptyEntity;
import entities.creatures.enemies.touhou.TouhouMinionEntity;
import java.util.ArrayList;
import strategies.logic.LeftToRightLogic;
import strategies.logic.RightToLeftLogic;
import strategies.logic.SimpleCircleLogic;
import util.Config;
import util.ResourceManager;

public class TouhouGameMode
extends GameMode {
    private int lives = Config.get(Config.playerLives);
    private int levelPhase;
    private int endTime;

    public TouhouGameMode(GameState gamestate) {
        super(gamestate);
    }

    @Override
    public void startScreen() {
        this.window.drawText(GameWindow.FONT_MENU, this.width / 2, 220.0f, "In Touhou mode you got finite lives.\nIf you run out of lives\nyou'll have to start from level 1 again.\n\nCan you beat this challenging mode?", 2);
    }

    @Override
    public void startLevel() {
        if (this.gamestate.getTime() - this.gamestate.getStartTime() < 10000L) {
            this.gamestate.setLevel(1);
        }
        this.levelPhase = 0;
        this.endTime = 0;
        TouhouEmptyEntity entity = new TouhouEmptyEntity(this.gamestate);
        this.gamestate.addEntity(entity);
        super.startLevel();
    }

    @Override
    public void render(long delta) {
        long levelDelta = this.gamestate.getTime() - this.gamestate.getLevelStartTime();
        this.window.drawText(GameWindow.FONT_MAIN_DIFFICULTY[this.gamestate.getDifficultyInt()], 55.0f, 573.0f, "Lives: " + this.lives);
        if (this.levelPhase == 0 && levelDelta > 1000L) {
            ++this.levelPhase;
        }
        block0 : switch (this.level) {
            case 1: {
                switch (this.levelPhase) {
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: {
                        this.waitForLevelPhaseEnd();
                        break block0;
                    }
                    case 1: {
                        TouhouMinionEntity minion = new TouhouMinionEntity(this.gamestate, 200, 200, new SimpleCircleLogic());
                        this.gamestate.addEntity(minion);
                        ++this.levelPhase;
                        break block0;
                    }
                    case 3: {
                        int i = 0;
                        while (i < 5) {
                            TouhouMinionEntity minion = new TouhouMinionEntity(this.gamestate, this.width + i * 49, 50, new RightToLeftLogic());
                            this.gamestate.addEntity(minion);
                            ++i;
                        }
                        ++this.levelPhase;
                        break block0;
                    }
                    case 5: {
                        int i = 0;
                        while (i < 5) {
                            TouhouMinionEntity minion = new TouhouMinionEntity(this.gamestate, -49 - i * 49, 120, new LeftToRightLogic());
                            this.gamestate.addEntity(minion);
                            ++i;
                        }
                        ++this.levelPhase;
                        break block0;
                    }
                    case 7: {
                        TouhouMinionEntity minion;
                        int i = 0;
                        while (i < 5) {
                            minion = new TouhouMinionEntity(this.gamestate, this.width + i * 49, 50, new RightToLeftLogic());
                            this.gamestate.addEntity(minion);
                            ++i;
                        }
                        i = 0;
                        while (i < 5) {
                            minion = new TouhouMinionEntity(this.gamestate, -49 - i * 49, 120, new LeftToRightLogic());
                            this.gamestate.addEntity(minion);
                            ++i;
                        }
                        ++this.levelPhase;
                        break block0;
                    }
                    case 9: {
                        this.touhouLevelEnd(delta);
                    }
                }
            }
        }
    }

    private void touhouLevelEnd(long delta) {
        this.endTime = (int)((long)this.endTime + delta);
        if (this.endTime < 1000) {
            return;
        }
        ArrayList<Entity> entities = this.gamestate.getEntities();
        for (Entity entity : entities) {
            if (!(entity instanceof TouhouEmptyEntity)) continue;
            this.gamestate.removeEntity(entity);
            break;
        }
    }

    private void waitForLevelPhaseEnd() {
        if (this.gamestate.getEnemyCount() == 1) {
            ++this.levelPhase;
        }
    }

    @Override
    public void playerDead() {
        --this.lives;
        if (this.lives == 0) {
            if (this.gamestate.isWaitingForKeyPress()) {
                return;
            }
            this.gamestate.increaseDeathCount();
            GameState.message.text = "You lost!\nPress Space to get back to main menu";
            GameState.message.x = this.width / 2;
            GameState.message.y = 245;
            this.gamestate.setWaitingForKeyPress(true);
            ResourceManager.get().playSound("level_lose");
        } else {
            this.gamestate.preparePlayerEntity();
        }
    }

    @Override
    public void afterGameLost() {
        ResourceManager.get().getGame().setState(State.MAIN_MENU);
    }
}

